/*
 * Decompiled with CFR 0.152.
 */
package com.princexml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class Chunk {
    private String mTag;
    private byte[] mBytes;

    private Chunk(String string, byte[] byArray) {
        this.mTag = string;
        this.mBytes = byArray;
    }

    public String getTag() {
        return this.mTag;
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    public String getString() {
        return new String(this.mBytes, Charset.forName("UTF-8"));
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.mBytes)));
    }

    public static Chunk readChunk(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[3];
        if (inputStream.read(byArray, 0, 3) != 3) {
            throw new IOException("failed to read chunk tag");
        }
        String string = new String(byArray, Charset.forName("ASCII"));
        int n2 = inputStream.read();
        if (n2 != 32) {
            throw new IOException("expected space after chunk tag");
        }
        int n3 = 0;
        int n4 = 9;
        for (n = 0; n < n4 + 1 && (n2 = inputStream.read()) != 10; ++n) {
            if (n2 < 48 || n2 > 57) {
                throw new IOException("unexpected character in chunk length");
            }
            n3 *= 10;
            n3 += n2 - 48;
        }
        if (n < 1 || n > n4) {
            throw new IOException("invalid chunk length");
        }
        byte[] byArray2 = new byte[n3];
        int n5 = 0;
        while (n3 > 0) {
            int n6 = inputStream.read(byArray2, n5, n3);
            if (n6 < 0) {
                throw new IOException("failed to read chunk data");
            }
            if (n6 > n3) {
                throw new IOException("unexpected read overrun");
            }
            n3 -= n6;
            n5 += n6;
        }
        n2 = inputStream.read();
        if (n2 != 10) {
            throw new IOException("expected newline after chunk data");
        }
        return new Chunk(string, byArray2);
    }

    public static void writeChunk(OutputStream outputStream, String string, String string2) throws IOException {
        Chunk.writeChunk(outputStream, string, string2.getBytes(Charset.forName("UTF-8")));
    }

    public static void writeChunk(OutputStream outputStream, String string, byte[] byArray) throws IOException {
        String string2 = string + " " + byArray.length + "\n";
        outputStream.write(string2.getBytes(Charset.forName("UTF-8")));
        outputStream.write(byArray);
        outputStream.write(10);
    }
}

