/*
 * Decompiled with CFR 0.152.
 */
package com.princexml;

import com.princexml.Chunk;
import com.princexml.Json;
import com.princexml.Prince;
import com.princexml.PrinceEvents;
import com.princexml.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class PrinceControl
extends Prince {
    private Process mProcess;
    private String mVersion;

    public PrinceControl(String string) {
        super(string);
    }

    public PrinceControl(String string, PrinceEvents princeEvents) {
        super(string, princeEvents);
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void start() throws IOException {
        if (this.mProcess != null) {
            throw new RuntimeException("control process has already been started");
        }
        List<String> list = this.getBaseCommandLine();
        list.add("--control");
        this.mProcess = Util.invokeProcess(list);
        InputStream inputStream = this.mProcess.getInputStream();
        Chunk chunk = Chunk.readChunk(inputStream);
        if (!chunk.getTag().equals("ver")) {
            if (chunk.getTag().equals("err")) {
                throw new IOException("error: " + chunk.getString());
            }
            throw new IOException("unknown chunk: " + chunk.getTag());
        }
        this.mVersion = chunk.getString();
    }

    public void stop() throws IOException {
        if (this.mProcess == null) {
            throw new RuntimeException("control process has not been started");
        }
        OutputStream outputStream = this.mProcess.getOutputStream();
        InputStream inputStream = this.mProcess.getInputStream();
        this.mProcess = null;
        Chunk.writeChunk(outputStream, "end", "");
        outputStream.close();
        inputStream.close();
    }

    @Override
    public boolean convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Util.copyInputToOutput(inputStream, byteArrayOutputStream);
        return this.convert(byteArrayOutputStream.toByteArray(), outputStream);
    }

    public boolean convert(byte[] byArray, OutputStream outputStream) throws IOException {
        if (this.mProcess == null) {
            throw new RuntimeException("control process has not been started");
        }
        OutputStream outputStream2 = this.mProcess.getOutputStream();
        InputStream inputStream = this.mProcess.getInputStream();
        Chunk.writeChunk(outputStream2, "job", this.getJobJSON());
        Chunk.writeChunk(outputStream2, "dat", byArray);
        outputStream2.flush();
        Chunk chunk = Chunk.readChunk(inputStream);
        if (chunk.getTag().equals("pdf")) {
            outputStream.write(chunk.getBytes());
            chunk = Chunk.readChunk(inputStream);
        }
        if (chunk.getTag().equals("log")) {
            return this.readMessages(chunk.getReader());
        }
        if (chunk.getTag().equals("err")) {
            throw new IOException("error: " + chunk.getString());
        }
        throw new IOException("unknown chunk: " + chunk.getTag());
    }

    private String getJobJSON() {
        Json json = new Json();
        json.beginObj();
        json.beginObj("input");
        if (this.mInputType != null) {
            json.field("type", this.mInputType);
        }
        if (this.mBaseURL != null) {
            json.field("base", this.mBaseURL);
        }
        json.field("javascript", this.mJavaScript);
        json.field("xinclude", this.mXInclude);
        json.beginList("styles");
        for (String string : this.mStyleSheets) {
            json.value(string);
        }
        json.endList();
        json.beginList("scripts");
        for (String string : this.mScripts) {
            json.value(string);
        }
        json.endList();
        json.endObj();
        json.beginObj("pdf");
        json.field("embed-fonts", this.mEmbedFonts);
        json.field("subset-fonts", this.mSubsetFonts);
        json.field("force-identity-encoding", this.mForceIdentityEncoding);
        json.field("compress", this.mCompress);
        if (this.mEncrypt) {
            json.beginObj("encrypt");
            json.field("key-bits", this.mKeyBits);
            if (this.mUserPassword != null) {
                json.field("user-password", this.mUserPassword);
            }
            if (this.mOwnerPassword != null) {
                json.field("owner-password", this.mOwnerPassword);
            }
            json.field("disallow-print", this.mDisallowPrint);
            json.field("disallow-modify", this.mDisallowModify);
            json.field("disallow-copy", this.mDisallowCopy);
            json.field("disallow-annotate", this.mDisallowAnnotate);
            json.endObj();
        }
        json.endObj();
        json.endObj();
        return json.toString();
    }
}

