/*
 * Decompiled with CFR 0.152.
 */
package com.princexml;

import com.princexml.PrinceEvents;
import com.princexml.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class Prince {
    private PrinceEvents mEvents;
    private String mExePath;
    protected ArrayList<String> mStyleSheets;
    protected ArrayList<String> mScripts;
    protected String mInputType;
    protected String mBaseURL;
    protected String mFileRoot;
    protected boolean mJavaScript;
    protected boolean mXInclude;
    private boolean mNetwork;
    private String mHttpUsername;
    private String mHttpPassword;
    private String mHttpProxy;
    private String mLogFile;
    private boolean mVerbose;
    private boolean mDebug;
    protected boolean mEmbedFonts;
    protected boolean mSubsetFonts;
    protected boolean mCompress;
    protected boolean mEncrypt;
    protected int mKeyBits;
    protected String mUserPassword;
    protected String mOwnerPassword;
    protected boolean mDisallowPrint;
    protected boolean mDisallowModify;
    protected boolean mDisallowCopy;
    protected boolean mDisallowAnnotate;
    private String[] mOptions;

    public Prince(String string) {
        this.init(string, null);
    }

    public Prince(String string, PrinceEvents princeEvents) {
        this.init(string, princeEvents);
    }

    private void init(String string, PrinceEvents princeEvents) {
        this.mEvents = princeEvents;
        this.mExePath = string;
        this.mStyleSheets = new ArrayList();
        this.mScripts = new ArrayList();
        this.mInputType = "auto";
        this.mBaseURL = null;
        this.mFileRoot = null;
        this.mJavaScript = false;
        this.mXInclude = true;
        this.mNetwork = true;
        this.mHttpUsername = null;
        this.mHttpPassword = null;
        this.mHttpProxy = null;
        this.mLogFile = null;
        this.mVerbose = false;
        this.mDebug = false;
        this.mEmbedFonts = true;
        this.mSubsetFonts = true;
        this.mCompress = true;
        this.mEncrypt = false;
        this.mKeyBits = 40;
        this.mUserPassword = "";
        this.mOwnerPassword = "";
        this.mDisallowPrint = false;
        this.mDisallowModify = false;
        this.mDisallowCopy = false;
        this.mDisallowAnnotate = false;
        this.mOptions = null;
    }

    public void addStyleSheet(String string) {
        this.mStyleSheets.add(string);
    }

    public void clearStyleSheets() {
        this.mStyleSheets.clear();
    }

    public void addScript(String string) {
        this.mScripts.add(string);
    }

    public void clearScripts() {
        this.mScripts.clear();
    }

    public void setHTML(boolean bl) {
        this.mInputType = bl ? "html" : "xml";
    }

    public void setInputType(String string) {
        this.mInputType = string;
    }

    public void setLog(String string) {
        this.mLogFile = string;
    }

    public void setVerbose(boolean bl) {
        this.mVerbose = bl;
    }

    public void setDebug(boolean bl) {
        this.mDebug = bl;
    }

    public void setBaseURL(String string) {
        this.mBaseURL = string;
    }

    public void setFileRoot(String string) {
        this.mFileRoot = string;
    }

    public void setJavaScript(boolean bl) {
        this.mJavaScript = bl;
    }

    public void setXInclude(boolean bl) {
        this.mXInclude = bl;
    }

    public void setNetwork(boolean bl) {
        this.mNetwork = bl;
    }

    public void setHttpUsername(String string) {
        this.mHttpUsername = string;
    }

    public void setHttpPassword(String string) {
        this.mHttpPassword = string;
    }

    public void setHttpProxy(String string) {
        this.mHttpProxy = string;
    }

    public void setEmbedFonts(boolean bl) {
        this.mEmbedFonts = bl;
    }

    public void setSubsetFonts(boolean bl) {
        this.mSubsetFonts = bl;
    }

    public void setCompress(boolean bl) {
        this.mCompress = bl;
    }

    public void setEncrypt(boolean bl) {
        this.mEncrypt = bl;
    }

    public void setEncryptInfo(int n, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (n != 40 && n != 128) {
            throw new IllegalArgumentException("invalid value for keyBits: " + n + " (must be 40 or 128)");
        }
        this.mEncrypt = true;
        this.mKeyBits = n;
        this.mUserPassword = string;
        this.mOwnerPassword = string2;
        this.mDisallowPrint = bl;
        this.mDisallowModify = bl2;
        this.mDisallowCopy = bl3;
        this.mDisallowAnnotate = bl4;
    }

    public void setOptions(String string) {
        if (string != null) {
            String[] stringArray = new String[]{string};
            this.mOptions = stringArray;
        } else {
            this.mOptions = null;
        }
    }

    public void setOptions(String[] stringArray) {
        this.mOptions = stringArray != null ? stringArray : null;
    }

    public boolean convert(String string) throws IOException {
        List<String> list = this.getJobCommandLine();
        list.add("--structured-log=normal");
        list.add(string);
        Process process = Util.invokeProcess(list);
        return this.readMessagesFromStderr(process);
    }

    public boolean convert(String string, String string2) throws IOException {
        List<String> list = this.getJobCommandLine();
        list.add("--structured-log=normal");
        list.add(string);
        list.add("--output=" + string2);
        Process process = Util.invokeProcess(list);
        return this.readMessagesFromStderr(process);
    }

    public boolean convertMultiple(List list, String string) throws IOException {
        List<String> list2 = this.getJobCommandLine();
        list2.add("--structured-log=normal");
        list2.add("--output=" + string);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            list2.add(string2);
        }
        Process process = Util.invokeProcess(list2);
        return this.readMessagesFromStderr(process);
    }

    public boolean convert(String string, OutputStream outputStream) throws IOException {
        List<String> list = this.getJobCommandLine();
        list.add("--structured-log=buffered");
        list.add(string);
        list.add("-o");
        list.add("-");
        Process process = Util.invokeProcess(list);
        InputStream inputStream = process.getInputStream();
        Util.copyInputToOutput(inputStream, outputStream);
        inputStream.close();
        return this.readMessagesFromStderr(process);
    }

    public boolean convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        List<String> list = this.getJobCommandLine();
        list.add("--structured-log=buffered");
        list.add("-");
        Process process = Util.invokeProcess(list);
        OutputStream outputStream2 = process.getOutputStream();
        InputStream inputStream2 = process.getInputStream();
        Util.copyInputToOutput(inputStream, outputStream2);
        outputStream2.close();
        Util.copyInputToOutput(inputStream2, outputStream);
        inputStream2.close();
        return this.readMessagesFromStderr(process);
    }

    protected List<String> getBaseCommandLine() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.mExePath);
        if (this.mFileRoot != null) {
            arrayList.add("--fileroot=" + this.mFileRoot);
        }
        if (!this.mNetwork) {
            arrayList.add("--no-network");
        }
        if (this.mHttpUsername != null) {
            arrayList.add("--http-user=" + this.mHttpUsername);
        }
        if (this.mHttpPassword != null) {
            arrayList.add("--http-password=" + this.mHttpPassword);
        }
        if (this.mHttpProxy != null) {
            arrayList.add("--http-proxy=" + this.mHttpProxy);
        }
        if (this.mLogFile != null) {
            arrayList.add("--log=" + this.mLogFile);
        }
        if (this.mVerbose) {
            arrayList.add("--verbose");
        }
        if (this.mDebug) {
            arrayList.add("--debug");
        }
        return arrayList;
    }

    protected List<String> getJobCommandLine() {
        String string;
        int n;
        List<String> list = this.getBaseCommandLine();
        for (n = 0; n < this.mStyleSheets.size(); ++n) {
            string = this.mStyleSheets.get(n);
            list.add("--style=" + string);
        }
        for (n = 0; n < this.mScripts.size(); ++n) {
            string = this.mScripts.get(n);
            list.add("--script=" + string);
        }
        if (this.mInputType != null && !this.mInputType.equals("auto")) {
            list.add("--input=" + this.mInputType);
        }
        if (this.mBaseURL != null) {
            list.add("--baseurl=" + this.mBaseURL);
        }
        if (this.mJavaScript) {
            list.add("--javascript");
        }
        if (!this.mXInclude) {
            list.add("--no-xinclude");
        }
        if (!this.mEmbedFonts) {
            list.add("--no-embed-fonts");
        }
        if (!this.mSubsetFonts) {
            list.add("--no-subset-fonts");
        }
        if (!this.mCompress) {
            list.add("--no-compress");
        }
        if (this.mEncrypt) {
            list.add("--encrypt");
            list.add("--key-bits=" + this.mKeyBits);
            if (this.mUserPassword != null && !this.mUserPassword.equals("")) {
                list.add("--user-password=" + this.mUserPassword);
            }
            if (this.mOwnerPassword != null && !this.mOwnerPassword.equals("")) {
                list.add("--owner-password=" + this.mOwnerPassword);
            }
            if (this.mDisallowPrint) {
                list.add("--disallow-print");
            }
            if (this.mDisallowModify) {
                list.add("--disallow-modify");
            }
            if (this.mDisallowCopy) {
                list.add("--disallow-copy");
            }
            if (this.mDisallowAnnotate) {
                list.add("--disallow-annotate");
            }
        }
        if (this.mOptions != null) {
            for (String string2 : this.mOptions) {
                list.add(string2);
            }
        }
        return list;
    }

    private boolean readMessagesFromStderr(Process process) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        return this.readMessages(bufferedReader);
    }

    protected boolean readMessages(BufferedReader bufferedReader) throws IOException {
        String string = "";
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (string2.length() >= 4) {
                String string3 = string2.substring(0, 4);
                String string4 = string2.substring(4);
                if (this.mEvents != null && string3.equals("msg|")) {
                    this.handleMessage(string4);
                } else if (string3.equals("fin|")) {
                    string = string4;
                }
            }
            string2 = bufferedReader.readLine();
        }
        return string.equals("success");
    }

    private void handleMessage(String string) {
        if (string.length() >= 4) {
            String string2 = string.substring(0, 3);
            String string3 = string.substring(4);
            int n = string3.indexOf(124);
            if (n != -1) {
                String string4 = string3.substring(0, n);
                String string5 = string3.substring(n);
                this.mEvents.onMessage(string2, string4, string5);
            }
        }
    }
}

