#! /bin/sh

PRODUCT="Prince"
PROGRAM="prince"
VERSION="5.1"
LICENSE="Demo"
WEBSITE="http://www.princexml.com"

prefix=/usr/local

echo "$PRODUCT $VERSION - $LICENSE License"
echo
echo "Install directory"
echo "    This is the directory in which $PRODUCT $VERSION will be installed."
echo "    Press Enter to accept the default directory or enter an alternative."
echo -n "    [$prefix]: "

read input
if [ ! -z "$input" ] ; then
    prefix="$input"
fi

echo
echo "Installing $PRODUCT $VERSION..."

# Create shell script

cat > prince <<EOF
#! /bin/sh

exec $prefix/lib/$PROGRAM/bin/$PROGRAM --prefix="$prefix/lib/$PROGRAM" "\$@"
EOF

# Create directories

bin="lib/$PROGRAM/bin"
license="lib/$PROGRAM/license"
style="lib/$PROGRAM/style"
fonts="lib/$PROGRAM/fonts"
dtd="lib/$PROGRAM/dtd"
ruby="$dtd/ruby"
svg10="$dtd/svg10"
svg11="$dtd/svg11"
xhtml1="$dtd/xhtml1"
xhtml11="$dtd/xhtml11"
xhtml_basic10="$dtd/xhtml-basic10"
xhtml_mod="$dtd/xhtml-mod"

install -d "$prefix/bin" "$prefix/$bin" "$prefix/$license" "$prefix/$style" "$prefix/$fonts" "$prefix/$dtd" "$prefix/$ruby" "$prefix/$svg10" "$prefix/$svg11" "$prefix/$xhtml1" "$prefix/$xhtml11" "$prefix/$xhtml_basic10" "$prefix/$xhtml_mod" 2>/dev/null ||
{
echo "    Unable to create directories in $prefix"
echo "    (You may need to be logged in as root to install programs in system"
echo "    directories. Ask your system administrator, or try installing inside"
echo "    your home directory, such as $HOME/$PROGRAM-$VERSION)."
echo
exit 1
}

# Install shell script and binary

install prince "$prefix/bin"
install "$bin/$PROGRAM" "$prefix/$bin"

# Install license

install -m 644 "$license/license.dat" "$prefix/$license"
install -m 644 "$license/splash.xml" "$prefix/$license"

# Install style sheets

install -m 644 "$style/fonts.css" "$prefix/$style"
install -m 644 "$style/xhtml.css" "$prefix/$style"
install -m 644 "$style/xhtml-ns.css" "$prefix/$style"
install -m 644 "$style/docbook.css" "$prefix/$style"
install -m 644 "$style/xlink.css" "$prefix/$style"

# Install fonts

install -m 644 "$fonts/deftone.ttf" "$prefix/$fonts"
install -m 644 "$fonts/efflbi__.ttf" "$prefix/$fonts"
install -m 644 "$fonts/efflb___.ttf" "$prefix/$fonts"
install -m 644 "$fonts/effli___.ttf" "$prefix/$fonts"
install -m 644 "$fonts/efflores.ttf" "$prefix/$fonts"
install -m 644 "$fonts/goodfisb.ttf" "$prefix/$fonts"
install -m 644 "$fonts/goodfisc.ttf" "$prefix/$fonts"
install -m 644 "$fonts/goodfish.ttf" "$prefix/$fonts"
install -m 644 "$fonts/goodfisi.ttf" "$prefix/$fonts"
install -m 644 "$fonts/minynbi_.ttf" "$prefix/$fonts"
install -m 644 "$fonts/minynb__.ttf" "$prefix/$fonts"
install -m 644 "$fonts/minyni__.ttf" "$prefix/$fonts"
install -m 644 "$fonts/minyn___.ttf" "$prefix/$fonts"
install -m 644 "$fonts/unisbi__.ttf" "$prefix/$fonts"
install -m 644 "$fonts/unisb___.ttf" "$prefix/$fonts"
install -m 644 "$fonts/unisi___.ttf" "$prefix/$fonts"
install -m 644 "$fonts/unispace.ttf" "$prefix/$fonts"

# Install DTD catalog

install -m 644 "$dtd/catalog.xml" "$prefix/$dtd"
install -m 644 "$dtd/ruby/xhtml-ruby-1.mod" "$prefix/$ruby"
install -m 644 "$dtd/svg10/svg10.dtd" "$prefix/$svg10"
install -m 644 "$dtd/svg11/svg-animation.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-animevents-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-basic-clip.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-basic-filter.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-basic-font.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-basic-graphics-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-basic-paint-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-basic-structure.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-basic-text.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-clip.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-conditional.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-container-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-core-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-cursor.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-datatypes.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-docevents-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-extensibility.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-extresources-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-filter.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-font.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-framework.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-gradient.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-graphevents-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-graphics-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-hyperlink.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-image.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-marker.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-mask.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-opacity-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-paint-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-pattern.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-profile.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-qname.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-script.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-shape.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-structure.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-style.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-text.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-view.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-viewport-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg-xlink-attrib.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg11-attribs.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg11-basic-attribs.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg11-basic-model.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg11-basic.dtd" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg11-model.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg11-tiny-attribs.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg11-tiny-model.mod" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg11-tiny.dtd" "$prefix/$svg11"
install -m 644 "$dtd/svg11/svg11.dtd" "$prefix/$svg11"
install -m 644 "$dtd/xhtml-basic10/xhtml-arch-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-attribs-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-base-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-basic-form-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-basic-table-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-basic10-model-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-basic10.dtd" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-blkphras-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-blkstruct-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-charent-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-datatypes-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-framework-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-hypertext-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-image-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-inlphras-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-inlstruct-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-lat1.ent" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-link-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-list-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-meta-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-notations-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-object-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-param-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-qname-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-special.ent" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-struct-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-symbol.ent" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-basic10/xhtml-text-1.mod" "$prefix/$xhtml_basic10"
install -m 644 "$dtd/xhtml-mod/xhtml-attribs-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-base-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-bdo-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-blkphras-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-blkpres-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-blkstruct-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-charent-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-csismap-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-datatypes-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-edit-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-events-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-form-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-framework-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-hypertext-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-image-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-inlphras-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-inlpres-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-inlstruct-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-inlstyle-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-lat1.ent" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-link-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-list-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-meta-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-notations-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-object-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-param-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-pres-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-qname-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-script-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-special.ent" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-ssismap-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-struct-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-style-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-symbol.ent" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-table-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml-mod/xhtml-text-1.mod" "$prefix/$xhtml_mod"
install -m 644 "$dtd/xhtml1/xhtml-lat1.ent" "$prefix/$xhtml1"
install -m 644 "$dtd/xhtml1/xhtml-special.ent" "$prefix/$xhtml1"
install -m 644 "$dtd/xhtml1/xhtml-symbol.ent" "$prefix/$xhtml1"
install -m 644 "$dtd/xhtml1/xhtml1-frameset.dtd" "$prefix/$xhtml1"
install -m 644 "$dtd/xhtml1/xhtml1-strict.dtd" "$prefix/$xhtml1"
install -m 644 "$dtd/xhtml1/xhtml1-transitional.dtd" "$prefix/$xhtml1"
install -m 644 "$dtd/xhtml11/xhtml11-model-1.mod" "$prefix/$xhtml11"
install -m 644 "$dtd/xhtml11/xhtml11.dtd" "$prefix/$xhtml11"

echo
echo "Installation complete."
echo "    Thank you for choosing $PRODUCT $VERSION, we hope you find it useful."
echo "    Please visit $WEBSITE for updates and development news."
echo

