/*
 * Decompiled with CFR 0.152.
 */
package com.princexml;

public class Json {
    private StringBuilder mStr = new StringBuilder();
    private boolean mComma = false;

    public Json beginObj() {
        if (this.mComma) {
            this.mStr.append(',');
        }
        this.mStr.append('{');
        this.mComma = false;
        return this;
    }

    public Json beginObj(String string) {
        if (this.mComma) {
            this.mStr.append(',');
        }
        this.mStr.append('\"');
        this.mStr.append(this.escape(string));
        this.mStr.append("\":{");
        this.mComma = false;
        return this;
    }

    public Json endObj() {
        this.mStr.append('}');
        this.mComma = true;
        return this;
    }

    public Json beginList(String string) {
        if (this.mComma) {
            this.mStr.append(',');
        }
        this.mStr.append('\"');
        this.mStr.append(this.escape(string));
        this.mStr.append("\":[");
        this.mComma = false;
        return this;
    }

    public Json endList() {
        this.mStr.append(']');
        this.mComma = true;
        return this;
    }

    public Json field(String string) {
        if (this.mComma) {
            this.mStr.append(',');
        }
        this.mStr.append('\"');
        this.mStr.append(this.escape(string));
        this.mStr.append("\":");
        this.mComma = false;
        return this;
    }

    public Json field(String string, String string2) {
        this.field(string);
        this.value(string2);
        return this;
    }

    public Json field(String string, boolean bl) {
        this.field(string);
        this.value(bl);
        return this;
    }

    public Json field(String string, int n) {
        this.field(string);
        this.value(n);
        return this;
    }

    public Json value(String string) {
        if (this.mComma) {
            this.mStr.append(',');
        }
        this.mStr.append('\"');
        this.mStr.append(this.escape(string));
        this.mStr.append('\"');
        this.mComma = true;
        return this;
    }

    public Json value(int n) {
        if (this.mComma) {
            this.mStr.append(',');
        }
        this.mStr.append(Integer.toString(n));
        this.mComma = true;
        return this;
    }

    public Json value(boolean bl) {
        if (this.mComma) {
            this.mStr.append(',');
        }
        this.mStr.append(bl ? "true" : "false");
        this.mComma = true;
        return this;
    }

    public String toString() {
        return this.mStr.toString();
    }

    private String escape(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

