
//This function prepares the TOC to be collapsible
function prepareList() {
  $('#expandable').find('li:has(ul)')
  	.click( function(event) {
  		if (this == event.target) {
  			$(this).toggleClass('expanded');
  			$(this).children('ul').toggle('medium');
  		}
  		return false;
  	})
  	.addClass('collapsed')
  	.children('ul').hide();
	
   
   $('#expandable a').unbind('click').click(function() {
		window.open($(this).attr('href'), "_self");
		return false;
	});
   
};
   

//This function captions images and creates a Table of Figures   
function captionImages() {
   //Adds a caption to each image found in the extract. 
   
   var tempImages = $('img');
   for(var x = 0; x < tempImages.length; x++) {
      if( !tempImages[x].getAttribute('class') ) {
         tempImages[x].setAttribute('class', 'images');
      }
   }
      
      var images = document.getElementsByClassName("images"),
      len = images.length, fig = document.createElement('figure'),
      who, temp;
      
      if(images.length > 1) {
      
         while(len) {
            temp = fig.cloneNode(false);
            who = images[--len];
            who.parentNode.insertBefore(temp, who);
            content = document.createElement( 'figcaption' );
            var altTemp = ""
            if(!who.alt) {
               altTemp = "No Captioncc";
            }
            else {
               altTemp = who.alt;
            }
            content.innerHTML = "<b name='figure' id='I" + len + "'><a href='#figHome'>" + 
            "Figure " + len + "</a> : " + altTemp + "</b><br><br>";
            if(len > 0) {
               temp.appendChild(content);
               temp.appendChild(who);
            }
         }
         
      //Creates a small Table of Figures at the bottom of the Table of Contents.  
         
         var tabOfFigures = "<nav role='navigation' class='table-of-figures'>" +
            "<h2 id='figHome'>Table of Figures:</h2>" + "<ul>";
         var figureTopics = document.getElementsByClassName("images");
         
         for(var ndx = 1; ndx<figureTopics.length; ndx++) {
            var altTemp = "";
            if(!figureTopics[ndx].alt) {
               altTemp = "No Captiondd";
            }
            else {
               altTemp = 'here' + figureTopics[ndx].alt;
            }
            var strTemp = "<li><a href='#I" + ndx + "'>Figure " + ndx + 
            "</a> - " + altTemp + "</li>";
            tabOfFigures += strTemp;
         }
         
         $(".tabOfCont").before(tabOfFigures);
      }
};


//This function captions tables and creates a Table of Tables
function captionTables() {
   //Adds a caption to each table found in the extract.
      
      var tables = $('div > table'),
      len = tables.length, fig = document.createElement('figure'),
      who, temp;
      if(tables.length > 0) {
      
         while(len) {
            temp = fig.cloneNode(false);
            who = tables[--len];
            capTemp =  who.caption;
            who.parentNode.insertBefore(temp, who);
            content = document.createElement( 'figcaption' );
            var capTemp = "";
            if(who.caption != null) {
               capTemp += who.caption.innerHTML;
            }
            else {
               capTemp += "  No Captionaa :: " + who.caption;
            }
            content.innerHTML = "<b name='table' id='T" + (len+1) + "'><a href='#tabHome'>" + 
            "Table " + (len+1) + "</a> : " + capTemp + "</b><br><br>";
            if(len > -1) {
               temp.appendChild(content);
               temp.appendChild(who);
            }
         }
         
      //Creates a small Table of Tables at the bottom of the Table of Contents.  
         
         var tabOfTables = "<nav role='navigation' class='table-of-tables'>" +
            "<h2 id='tabHome'>Table of Tables:</h2>" + "<ul>";
         var tableTopics = tables;
      
         
         for(var ndx = 0; ndx<tableTopics.length; ndx++) {
            var capTemp = "";
            if(tableTopics[ndx].caption != null) {
               capTemp = tableTopics[ndx].caption.innerHTML;
               //tableTopics[ndx].deleteCaption();
            }
            else {
               capTemp = "No Captionbb";
            }
            var strTemp = "<li><a href='#T" + (ndx+1) + "'>Table " + (ndx+1) + 
            "</a> - " + capTemp + "</li>";
            tabOfTables += strTemp;
         }
         
         /*
         for(var ndx2 = 0; ndx2<others.length; ndx2++) {
            if(others[ndx2].caption != null) {
               others[ndx2].deleteCaption();
            }
         }
         */
         
         $(".tabOfCont").before(tabOfTables);
      }
};


//This function takes wide images and reduces the images in size 
//keeping the aspect ratio
function normalizeImages() {
   $('div img').each(function(index){
     if($(this).width() > 900){
        $(this).width(900);
      }
   });
};


//This function takes wide tables and reduces the tables in size 
//keeping the aspect ratio
function normalizeTables() {
   $('div table').each(function(index){
     if($(this).width() > 900){
        $(this).width(900);
      }
   });
};

   
//Once document is loaded/rendered, run all this
$( document ).ready(function() {
	
   var toc = document.getElementsByClassName("toc");
   
   if(toc.length > 0) {
   
	//expand TOC when printing and then collapse back
	(function() {
    var beforePrint = function() {
        //alert('Functionality to run before printing.');
		$('#expandable').find('li:has(ul)').children('ul').show();
		$('.collapsed').addClass('expanded');
    };
    var afterPrint = function() {
        //alert('Functionality to run after printing');
		$('#expandable').find('li:has(ul)').children('ul').hide();
		$('.collapsed').removeClass('expanded');
    };

    if (window.matchMedia) {
        var mediaQueryList = window.matchMedia('print');
        mediaQueryList.addListener(function(mql) {
            if (mql.matches) {
                beforePrint();
            } else {
                afterPrint();
            }
        });
    }

    window.onbeforeprint = beforePrint;
    window.onafterprint = afterPrint;
   }());
	
      // 'merge' symbol and parameter cells if they are the same
		$('.ectable table').each(function()
		{
		    var ecTable = $(this);
		    var rowCount = $(this).find('tr:last').index() + 1;
		    var i = 0;
		    while (i < rowCount) {
		        var currentRow = $(this).find("tr:eq(" + i + ")");
		        var seenArray = {};
		        $(currentRow).find(".symbol, .parameter").each(function () {
		            var repeatCount = 0;
		            var index = $(this).index();
					var txt = $(this).text();
					var j = i + 1;
					while (j < rowCount) {
						var nextRow = $(ecTable).find("tr:eq(" + j + ")");
						var nextCell = $(nextRow).find("td:eq(" + index + ")");
						if (nextCell.text() === txt) {
							nextCell.hide();
							repeatCount++;
						}
						else {
							break;
						}
						j++;
					}
					$(this).attr('rowspan', repeatCount+1);
		        });
		        i++;
		    }
		});	
		
		var pageSec = "<div class ='pageSection'></div>"
		var divs = $(".infoSec");
		var totalLength = $(".infoSec").length;
		var height = 0;
		var count =0;
		
		var pageHeight = 1370;
		var pageNum = 0;
		
		//divide extract into pages
		$(".infoSec").each(function(index) {	
			height += $(this).outerHeight();
         
         //wrap last infoSec
			if(index == totalLength-1){
				divs.slice(count,index+1).wrapAll(pageSec);
			}
         //wrap pages if height greater than page height (random number I found that seems to mostly work), less than pageHeight for buffer
			else if(height >= 1140 ){
				height = $(this).height();
				pageNum++;
				
				divs.slice(count,index).wrapAll(pageSec);
				$("body").find(".pageSection").last().attr('id', 'p' + pageNum);
				var currHeight = $("body").find(".pageSection").last().height(),
				lastElmHeight = $("body").find(".pageSection").last().children().last().height();
				
            //	(not completely working) unwrap last sections of page if page height is too great (made to address edge case where one page was too long)
				if(currHeight >= pageHeight && lastElmHeight <= 900){
					var extra = currHeight - pageHeight;
				
					divs.slice(count,index).unwrap();
					var i = 0; 
					while(extra >= 0){
						i++;
						height += divs.slice(index-i).height();
						extra -= divs.slice(index-i).height();
					}
					divs.slice(count,index-i).wrapAll(pageSec);
					count = index -i;
				}
				else
					count = index;
				
			}
			
		});
		
		//add page number and watermark to each page
		var numPages = pageNum;
		var pageCSS, watermark;
		$(".pageSection").each(function(index){
			pageCSS = "<div style='margin:auto;'><p style='margin-left: 880px; font-size:20px'>" + (index+1) + "</p></div>";
			watermark = "<div class = 'watermark-test infoSec'>Watermark Test</div>"
			$(this).prepend(pageCSS);
			$(this).prepend(watermark);
			$(this).attr('id', 'p' + (index+1));
		});
      
		var ToC =
		  "<nav role='navigation' class='table-of-contents'>" +
			"<h2><a name = 'TOC'>Table of Contents:</a></h2>" +
			"<ul id = 'expandable'>";
		
		var newLine, el, title, link;
		var newLine2, el2, title2, link2, subHead, subHead2, position;
		

		//Create the dynamic table of contents
		$("body h2").each(function() {
			

		  el = $(this);
		  title = el.text();
		  link = "#" + el.attr("id");
		  pageNum = $(this).parents(".pageSection").attr("id");

         //first level li
         if(typeof pageNum !== 'undefined') {
		      newLine = "<li>" + "<a href='" + link + "'>" + title +
			      "</a>" + "<span style = 'float:right; margin-right: 40%'> page " + 
               pageNum + "</span></li>";
         }
         else {
            newLine = "<li>" + "<a href='" + link + "'>" + title + 
            "</a><span style = 'float:right; margin-right: 40%'></span></li>";
         }
         
			var subheads =
			subHead = "";
			title2 = "";
         
         //second level of li
			$(this).nextAll(".indent").each(function(){
				$(this).children(".toc_sub").each(function(){
					el2 = $(this);
					title2 = el2.text();
					link2 = "#" + el2.attr("id");
					newLine2 =  "<ul>" + "<li>" +
								  "<a href='" + link2 + "'>" +
									title2 +
								  "</a>" + "</li>" + "</ul>"
								;
					subHead += newLine2;
				});
				subHead2 = "";
            
            //third level of li
				$(this).children(".indent").each(function(){
					$(this).children(".toc_sub").each(function(){
						el2 = $(this);
						title2 = el2.text();
						link2 = "#" + el2.attr("id");
						newLine2 =  "<ul>" + "<li>" +
									  "<a href='" + link2 + "'>" +
										title2 +
									  "</a>" + "</li>" + "</ul>"
									;
						subHead2 += newLine2;
					});
				});
				position = subHead.length-10;
				subHead = [subHead.slice(0, position), subHead2, subHead.slice(position)].join('');
			});

			position = newLine.length-5;
			newLine = [newLine.slice(0, position), subHead, newLine.slice(position)].join('');

			ToC += newLine;
			
			 // Get the content
			var str = $(this).html();
			// Replace plain text links by hyperlinks
			var replaced_text = str.replace(title, "<a href='#TOC'>" + title + "</a>");
			// Echo link
			$(this).html(replaced_text);
		});
		$(".table-of-contents").prepend("<div class='listControl'><a id='expandList'></a>Expand All <a id='collapseList'></a>Collapse All</div>");
		$(".tabOfCont").before(ToC);

		prepareList();
		
		
      //Caption Images and Tables
      captionTables();
      captionImages();
      
   }
   
      //Split the sections of the document into pages 
      var pageSec = "<div class ='pageSection'></div>"
		var divs = $(".infoSec");
		var totalLength = $(".infoSec").length;
		var height = 0;
		var count =0;
		var pageHeight = 1370;
		var pageNum = 0;
		
		//divide extract into pages
		$(".infoSec").each(function(index) {		
			height += $(this).outerHeight();
			//alert("1 h" + height);
			//alert("1 out" + $(this).outerHeight());
			if(index == totalLength-1){
				//alert("last");
				divs.slice(count,index+1).wrapAll(pageSec);
			}
			else if(height >= 1140 ){
				height = $(this).height();
				//alert("height " +height + " count " + count);
				divs.slice(count,index).wrapAll(pageSec);
				var currHeight = $("body").find(".pageSection").last().height(),
				lastElmHeight = $("body").find(".pageSection").last().children().last().height();
				
				
					count = index;
				
			}
			
			
		});
      
      //Cap the width of tables/images for printing and viewing purposes
      normalizeImages();
      normalizeTables();

});
