var FONT_SIZE_INCREASE = 100;
var fsDictionary = {};

function checkFontSize(elem) {
	if (elem.childNodes != null)
	{
		for (var i = 0 ; i < elem.childNodes.length ; i++)
		{
			checkFontSize(elem.childNodes[i]);
		}
	}

	if (elem.nodeType != 1)
	{
		return;
	}

    var fontSize

    var key = elem.tagName + '_' + elem.className + '_' + elem.style.fontSize;
    if (fsDictionary[key] !== undefined && fsDictionary[key] !== null)
    {
        fontSize = fsDictionary[key];
    }
    else {
        fontSize = window.getComputedStyle(elem).fontSize;
        var unit = fontSize.substring(fontSize.length - 2, fontSize.length);
        fontSize = Number(fontSize.substring(0, fontSize.length - 2));
        fontSize = fontSize + FONT_SIZE_INCREASE + unit;

        // Store the value in the dictionary
        fsDictionary[key] = fontSize;
    }

    if (elem.id == "bookmark")
    {
    	console.log("Before increase");
    	printProperties(elem);
    	console.log("");
	}

	elem.style.fontSize = fontSize;
	
    if (elem.id == "bookmark")
    {
    	console.log("After increase");
    	printProperties(elem);
    	console.log("");
	}
}

function printProperties(el)
{
	var nodes=[], values=[];
	for (var att, i = 0, atts = el.attributes, n = atts.length; i < n; i++)
	{
	    att = atts[i];
	    console.log(att.nodeName + " = " + att.nodeValue);
	}
}

checkFontSize(document.body);