package oom;

import com.princexml.wrapper.events.MessageType;
import com.princexml.wrapper.events.PrinceEvents;

public class PrinceEventHandler implements PrinceEvents {
	private final static String kPAGE_COUNT = "|total-page-count ";

	private long generatedPages = -1;

	public void resetStatistics() {
		generatedPages = -1;
	}

	@Override
	public void onMessage(final MessageType msgType, final String msgLocation, final String msgText) {
		if (msgText.startsWith(kPAGE_COUNT)) {
			try {
				generatedPages = Long.parseLong(msgText.substring(kPAGE_COUNT.length()));
			} catch (final Exception e) {
				System.out.println("Could not retrieve number of generated pages from [" + msgText + "]");
			}
		}
	}

	@Override
	public void onDataMessage(String name, String value) {
	}

}