package oom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

import com.princexml.wrapper.CustomPrinceControl;

/**
 * This test reads an input HTML file converts it to a PDF document, as many times as requested 1 to 1.
 */
public class PrinceTestManySmall {

	public static void main(final String[] args) throws Exception {
		if (args.length != 2) {
			throw new IllegalArgumentException("Usage: java " + PrinceTestManySmall.class.getName() + " INPUT_FILE COUNT");
		}
		
		PrinceEventHandler princeEventHandler = new PrinceEventHandler();
		CustomPrinceControl prince = new CustomPrinceControl(System.getenv().getOrDefault("PRINCE_COMMAND", "prince"),
				princeEventHandler);
		prince.start();
		System.out.println("running with " + prince.getVersion());

		List<InputStream> inputStreams = prepareInputStreams(args[0], 1);
		
		try (Scanner s = new Scanner(System.in)) {
			while (true) {
				System.out.format("Converting %d times with prince...", Integer.parseInt(args[1]));
				boolean success = true;
				for (int i = 0; i < Integer.parseInt(args[1]); i++) {
					try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
						success &= prince.convertListOfInputStreams(inputStreams, out);
						resetInputStreams(inputStreams);
					}
				}
				System.out.format("Convert successful = %s\n", success);
				System.out.println(
						"\nType 'exit' and hit enter to exit or hit enter to go again with the same PrinceControl.");
				String userInput = s.nextLine();
				if ("exit".equalsIgnoreCase(userInput)) {
					break;
				} else {
					resetInputStreams(inputStreams);
				}
			}
		} finally {
			prince.stop();
		}
	}

	private static void resetInputStreams(List<InputStream> inputStreams) throws IOException {
		for (InputStream inputStream : inputStreams) {
			inputStream.reset();
		}
	}
	
	private static List<InputStream> prepareInputStreams(String inputFileName, Integer maxCount) throws IOException{
		byte[] inputBytes = Files.readAllBytes(Paths.get(inputFileName));
		List<InputStream> inputStreams = new LinkedList<>();
		System.out.println("preparing input streams");
		for (int count = 1; maxCount == null || count <= maxCount.intValue(); count++) {
			InputStream is = new ByteArrayInputStream(inputBytes);
			inputStreams.add(is);
		}
		return inputStreams;
	}

}
