require 'fileutils'
require 'logger'
require 'rubygems'
gem 'open4', '1.0.1'
require 'open4'

def run_command(cmd, logger)
  output        = 'n/a'
  error_message = 'n/a'

  status = Open4::popen4(cmd) do |pid, stdin, stdout, stderr|
    error_message = stderr.read
    output = stdout.read
  end
  
  logger.info <<-STUFF
    Running command '#{cmd}'
    -----
    output: #{output}
    -----
    status: #{status.exitstatus} (success: #{status.success?})
    -----
    error:  #{error_message}
    -----
  STUFF
end


Dir.glob("example*.html").each do |file_name|
  cmd = "prince --media=print --no-xinclude --ssl-blindly-trust-server --no-embed-fonts #{file_name} --output #{file_name}.pdf"
  
  File.open("#{file_name}.output", "w") do |output_file|
    logger = Logger.new(output_file)
    run_command(cmd, logger)
  end
end