var timer;
(function($) {
	$(document).ready(function(){

		timer = setTimeout("window.location=\"https://" + parent + "/INV/ResearchAndMarketData/IDCTimeout\"", 3600000);

		$('*').live('click', resetTimeout)
			  .live('change', resetTimeout)
			  .live('focus', resetTimeout);

	});
})(jQuery);

function resetTimeout(){
	clearTimeout(timer);

	timer = setTimeout("window.location=\"https://" + parent + "/INV/ResearchAndMarketData/IDCTimeout\"", 3600000);
}

function ShowAJAXProgress(div, id) {
    var divwidth = $("#" + div).width();
    var divheight = $("#" + div).height();
    var divpos = $("#" + div).offset();
    if($("#" + div + ' #Loading' + id).length == 0){
	    $("#" + div).append('<div id="Loading' + id + '"><img alt="" src="../images/spinner.gif"/></div>');
	    $("#" + div).append('<div id="LoadingBG' + id + '" style="background-color:#DDDDDD; filter:alpha(opacity=70); opacity:0.7;"></div>');
	    $("#Loading" + id).css({ "position": "absolute", "left": divpos.left + (divwidth / 2) + "px", "top": divpos.top + (divheight / 2) + "px" });
	    $("#LoadingBG" + id).css({ "position": "absolute", "left": divpos.left + "px", "top": divpos.top + "px", "height": divheight + "px", "width": divwidth + "px" });
    }
}

function HideAJAXProgress(id) {
    setTimeout('$("#Loading' + id + '").remove(); $("#LoadingBG' + id + '").remove();', 100);
}

function writeShortVolume(val) {
    var postfix = "";
    if (val != "") {
        val = parseFloat(val);
        if (val > 1000000) {
            val = val / 1000000;
            postfix = "M";
        }
        if (val > 1000) {
            if (postfix != "") {
                val = val / 1000;
                postfix = "B";
            }
        }
    }
    return val.toFixed(1) + postfix;
}
